set sql_safe_updates=0;

-- Appointment

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_VELOCITY_RECIPIENTS');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.code AS ENQUIRY_CODE,
    T1.firstName AS PARENT_FIRSTNAME,
    T1.lastName AS PARENT_LASTNAME,
    T2.studentFirstName AS STUDENT_FIRSTNAME,
    T2.studentLastName AS STUDENT_LASTNAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    T1.primaryeEmailId AS EMAIL_ID,
    T1.phoneNo AS MOBILE_NO,
    T1.phoneCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
	T4.academyid AS ACADEMY_ID,
	T4.locationid AS LOCATION_ID,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL    
FROM
    enquiry T1
        LEFT JOIN
    enq_student_details T2 ON T2.enquiryId = T1.id
        LEFT JOIN
    admission_enq_details T3 ON T3.enqStudentDetailsId = T2.id
        LEFT JOIN
    academy_location T4 ON T4.id = T3.academyLocationId
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId
        LEFT JOIN
    organizations org on org.id = 1
WHERE
    T1.id IN (namedParams) and T6.addressTypeId=10",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "STUDENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "STUDENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAIL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "websiteURL",
            "resultKey": "WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "locationId",
            "resultKey": "LOCATION_ID",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
}' WHERE `dataProviderId` = @sgAppointmentDT;

-- Msg Template
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='CREATE_ENQUIRY_VELOCITY');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='CREATE_ENQUIRY_VELOCITY');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='CREATE_ENQUIRY_VELOCITY_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications'); 

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Create Enquiry Buzz Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Create Enquiry Buzz Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Welcome - We can’t wait to meet you!','<html>
<head>
    <title></title>
</head>
<body>
<img height="80" width="100%" src="$recipientData[&quot;HEADER_URL&quot;]"/>
<p>Lead ID&nbsp;<strong>$recipientData[&quot;ENQUIRY_CODE&quot;]</strong></p>

<p>Dear&nbsp;<strong>$recipientData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;PARENT_LASTNAME&quot;]</strong></p>

<p>Thank you for your interest in <strong>$recipientData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LASTNAME&quot;]</strong>&nbsp;joining our ever-growing <strong>$recipientData[&quot;ACADEMY_NAME&quot;]</strong>&nbsp;community. We look forward to a long and prosperous relationship with both you and your child. In fact, we have a dedicated team of staff who are ready and waiting to answer any questions you may have.</p>

<p><strong>What&rsquo;s the next step?</strong></p>

<p>If you require more information on our school or require any further assistance, please click here<br />
<strong>$recipientData[&quot;ACADEMY_EMAIL&quot;]</strong>&nbsp;and the school will contact you telephonically to discuss.</p>

<p><br />
If you are interested in applying for admission to our school, please click here <strong>$recipientData[&quot;WEBSITE_URL&quot;]</strong>&nbsp;to get the process started. Your application will be assessed and, depending on the grade (form or standard) you are enquiring for, an assessment/interview may be scheduled. If the assessment/interview has been successful, you will receive a &ldquo;Conditional Admission&rdquo; letter and on acceptance of the offer you will be able to complete the admission process by paying the relevant enrolment fee or submitting other required information as applicable.</p>

<p>We can&rsquo;t wait to hear back from you!</p>

<p>Kind regards,<br />
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>
<img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" />
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["PARENT_FIRSTNAME"] $recipientData["PARENT_LASTNAME"],
Thank you for your interest in our school. We will be touch shortly. 
$recipientData["ACADEMY_NAME_LOCATION"]');

set sql_safe_updates=1;

